package com.biz.crm.nebular.dms.order;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 订单覆盖导入
 * @Author: chenrong
 * @Date: 2021/3/24 17:50
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "OrderUpdateImportVo", description = "订单覆盖导入vo")
public class OrderUpdateImportVo extends AbstractImportVo implements Serializable {

  private static final long serialVersionUID = 5267198066838965345L;

  @ExcelProperty(value = "客户编码", index = 0)
  @ColumnWidth(20)
  private String cusCode;

  @ExcelProperty(value = "客户名称", index = 1)
  @ColumnWidth(20)
  private String cusName;

  @ExcelProperty(value = "订单类型编码(订单类型不允许修改，如果修改了，原有的促销商品无法替换，如果在excel表里修改了订单类型后果自负)")
  @ExcelIgnore
  private String orderTypeCode;

  @ExcelProperty(value = "订单类型名称", index = 2)
  @ColumnWidth(20)
  private String orderTypeName;

  @ExcelProperty(value = "订单编码", index = 3)
  @ColumnWidth(20)
  private String orderCode;

  @ExcelProperty(value = "商品编码", index = 4)
  @ColumnWidth(20)
  private String productCode;

  @ExcelProperty(value = "商品名称", index = 5)
  @ColumnWidth(20)
  private String productName;

  @ExcelProperty(value = "购买数量", index = 6)
  @ColumnWidth(20)
  private String count;

  @ExcelProperty(value = "行项目id", index = 7)
  @ColumnWidth(20)
  private String detailId;

  @ExcelProperty(value = "促销政策id", index = 8)
  @ColumnWidth(20)
  private String promotionId;

  @ExcelProperty(value = "促销类型", index = 9)
  @ColumnWidth(20)
  private String promotionType;

  @ExcelProperty(value = "促销购买数量", index = 10)
  @ColumnWidth(20)
  private String promotionBuyCount;

  @ExcelProperty(value = "促销赠送数量", index = 11)
  @ColumnWidth(20)
  private String promotionGiftCount;

  @ExcelProperty(value = "商品类型", index = 12)
  @ColumnWidth(20)
  private String productType;

  @ExcelProperty(value = "费用池编码", index = 13)
  @ColumnWidth(20)
  private String feeCode;

  @ExcelProperty(value = "费用池名称", index = 14)
  @ColumnWidth(20)
  private String feeName;

  @ExcelProperty(value = "订单id")
  @ExcelIgnore
  private String id;

  @ExcelProperty(value = "价格")
  @ExcelIgnore
  private BigDecimal price;

  @ExcelProperty(value = "金额")
  @ExcelIgnore
  private BigDecimal amount;
}
