package com.biz.crm.nebular.dms.promotion;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@ApiModel(value = "促销政策编辑页面-促销规则")
@SaturnEntity(name = "PromotionPolicyRule", description = "促销政策编辑页面-促销规则")
@Data
public class PromotionPolicyRule extends UuidVo implements Serializable {
    /**
     * 促销规则-条件
     */
    @ApiModelProperty(value = "促销规则-条件")
    @SaturnColumn(description = "促销规则-条件")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<PromotionPolicyRuleEditVo> rulesAsCondition;
    /**
     * 促销规则-计算
     */
    @ApiModelProperty(value = "促销规则-计算")
    @SaturnColumn(description = "促销规则-计算")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<PromotionPolicyRuleEditVo> rulesAsCalculate;
    /**
     * 促销规则-限量
     */
    @ApiModelProperty(value = "促销规则-限量")
    @SaturnColumn(description = "促销规则-限量")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<PromotionPolicyRuleEditVo> rulesAsLimited;
}
