package com.biz.crm.nebular.fee.pool.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 折扣费用池使用金额请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolDiscountUseReqVo", description = "折扣费用池使用金额请求VO")
public class FeePoolDiscountUseReqVo {

    @ApiModelProperty("使用类型，不填表示默认")
    private String useType;

    @ApiModelProperty("使用金额（必填）")
    private BigDecimal amount;

}