package com.biz.crm.nebular.fee.pool.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 费用池明细表返回vo
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用池明细表")
@CrmColumnResolve
public class FeePoolDetailPageRespVo extends CrmExtTenVo {

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("费用池明细编号")
    private String poolDetailCode;

    @ApiModelProperty("操作记录编号")
    private String operationCode;

    @ApiModelProperty("上账类型")
    private String operationType;

    @ApiModelProperty("来源编号")
    private String fromCode;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("上账时间yyyy-MM-dd HH:mm:ss")
    private String accountDateTime;

    @ApiModelProperty("上账金额/数量")
    private BigDecimal totalAmount;

    @ApiModelProperty("冻结金额/数量")
    private BigDecimal freezeAmount;

    @ApiModelProperty("占用金额/数量")
    private BigDecimal occupyAmount;

    @ApiModelProperty("已使用金额/数量")
    private BigDecimal hasUseAmount;

    @ApiModelProperty("剩余可使用金额/数量")
    private BigDecimal usableAmount;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动类型")
    private String actType;

    @ApiModelProperty("活动类型名称")
    private String actTypeName;

    @ApiModelProperty("活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    private String fineName;

    @ApiModelProperty("活动大类编码")
    private String categoriesCode;

    @ApiModelProperty("活动大类名称")
    private String categoriesName;

    @ApiModelProperty("会计科目编码")
    private String budgetSubjectsCode;

    @ApiModelProperty("会计科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("核销编码")
    private String auditCode;

    @ApiModelProperty("核销明细编码")
    private String auditDetailCode;

    @ApiModelProperty("附件")
    private List<FeePoolFileRespVo> fileList;

    @ApiModelProperty("（主表维度）客户编码")
    private String customerCode;

    @ApiModelProperty("（主表维度）客户名称")
    private String customerName;

    @ApiModelProperty("（主表维度）组织编码(可能是集合，英文逗号间隔)")
    private String orgCode;

    @ApiModelProperty("（主表维度）组织名称(可能是集合，英文逗号间隔)")
    private String orgName;

    @ApiModelProperty("（主表维度）渠道类型")
    private String channelType;

    @ApiModelProperty("（主表维度）erp编码")
    private String erpCode;

    @ApiModelProperty("（主表维度）销售公司编码")
    private String saleCompanyCode;

    @ApiModelProperty("（主表维度）费用池分组")
    private String poolGroup;

    @ApiModelProperty("（主表维度）费用池类型")
    private String poolType;

    @ApiModelProperty("（主表维度）支付方式")
    private String payType;

    @ApiModelProperty("（主表维度）费用使用类型")
    private String useType;

    @ApiModelProperty("（主表维度）货补产品层级编码")
    private String goodsProductLevelCode;

    @ApiModelProperty("（主表维度）货补产品层级名称")
    private String goodsProductLevelName;

    @ApiModelProperty("（主表维度）货补商品编码(可能是集合，排序之后，英文逗号间隔)")
    private String goodsProductCode;

    @ApiModelProperty("（主表维度）货补商品名称(可能是集合，排序之后，英文逗号间隔)")
    private String goodsProductName;

    @ApiModelProperty("（主表维度）费用池主表预留字段1")
    private String poolExt1;

    @ApiModelProperty("（主表维度）费用池主表预留字段2")
    private String poolExt2;

    @ApiModelProperty("（主表维度）费用池主表预留字段3")
    private String poolExt3;

    @ApiModelProperty("（主表维度）费用池主表预留字段4")
    private String poolExt4;

    @ApiModelProperty("（主表维度）费用池主表预留字段5")
    private String poolExt5;

    @ApiModelProperty("费用池主表预留字段6")
    private String poolExt6;

    @ApiModelProperty("费用池主表预留字段7")
    private String poolExt7;

    @ApiModelProperty("费用池主表预留字段8")
    private String poolExt8;

    @ApiModelProperty("费用池主表预留字段9")
    private String poolExt9;

    @ApiModelProperty("费用池主表预留字段10")
    private String poolExt10;

    @ApiModelProperty("费用池分组")
    @CrmDict(typeCode = DictConstant.FEE_POOL_GROUP, dictCodeField = "poolGroup")
    private String poolGroupName;

    @ApiModelProperty("上账类型")
    @CrmDict(typeCode = DictConstant.FEE_POOL_OPERATION_TYPE, dictCodeField = "operationType")
    private String operationTypeName;

    @ApiModelProperty("支付方式")
    @CrmDict(typeCode = DictConstant.FEE_POOL_PAY_TYPE, dictCodeField = "payType")
    private String payTypeName;

    @ApiModelProperty("费用池类型")
    @CrmDict(typeCode = DictConstant.FEE_POOL_TYPE, dictCodeField = "poolType")
    private String poolTypeName;

    @ApiModelProperty("费用使用类型")
    @CrmDict(typeCode = DictConstant.FEE_POOL_USE_TYPE, dictCodeField = "useType")
    private String useTypeName;

}