package com.biz.crm.nebular.fee.pool.resp;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 货补费用池产品明细返回VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "货补费用池产品明细返回VO")
@CrmColumnResolve
public class FeePoolGoodsProductRespVo {

    @ApiModelProperty("货补产品编码")
    private String productCode;

    @ApiModelProperty("货补产品名称")
    private String productName;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("销售单位(字典编码)")
    private String saleUnit;

    @ApiModelProperty("销售单位")
    private String saleUnitName;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("获取一张图片")
    private String mainPictureUrl;

}