package com.biz.crm.nebular.fee.pool.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 费用池主表返回vo
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用池主表")
@CrmColumnResolve
public class FeePoolRespVo extends CrmBaseVo {

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("费用池类型")
    private String poolType;

    @ApiModelProperty("支付方式")
    private String payType;

    @ApiModelProperty("渠道类型")
    private String channelType;

    @ApiModelProperty("组织编码(可能是集合，英文逗号间隔)")
    private String orgCode;

    @ApiModelProperty("组织名称(可能是集合，英文逗号间隔)")
    private String orgName;

    @ApiModelProperty("erp编码")
    private String erpCode;

    @ApiModelProperty("销售公司编码")
    private String saleCompanyCode;

    @ApiModelProperty("费用使用类型")
    private String useType;

    @ApiModelProperty("货补产品层级编码")
    private String goodsProductLevelCode;

    @ApiModelProperty("货补产品层级名称")
    private String goodsProductLevelName;

    @ApiModelProperty("货补商品编码(可能是集合，排序之后，英文逗号间隔)")
    private String goodsProductCode;

    @ApiModelProperty("货补商品名称(可能是集合，排序之后，英文逗号间隔)")
    private String goodsProductName;

    @ApiModelProperty("总金额/数量")
    private BigDecimal totalAmount;

    @ApiModelProperty("冻结金额/数量")
    private BigDecimal freezeAmount;

    @ApiModelProperty("占用金额/数量")
    private BigDecimal occupyAmount;

    @ApiModelProperty("已使用金额/数量")
    private BigDecimal hasUseAmount;

    @ApiModelProperty("剩余可使用金额")
    private BigDecimal usableAmount;

    @ApiModelProperty("费用池主表预留字段1")
    private String poolExt1;

    @ApiModelProperty("费用池主表预留字段2")
    private String poolExt2;

    @ApiModelProperty("费用池主表预留字段3")
    private String poolExt3;

    @ApiModelProperty("费用池主表预留字段4")
    private String poolExt4;

    @ApiModelProperty("费用池主表预留字段5")
    private String poolExt5;

    @ApiModelProperty("费用池主表预留字段6")
    private String poolExt6;

    @ApiModelProperty("费用池主表预留字段7")
    private String poolExt7;

    @ApiModelProperty("费用池主表预留字段8")
    private String poolExt8;

    @ApiModelProperty("费用池主表预留字段9")
    private String poolExt9;

    @ApiModelProperty("费用池主表预留字段10")
    private String poolExt10;
}