package com.biz.crm.nebular.job.resp;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 返回vo
 *
 * @author jerry7
 * @date 2021-02-19 11:37:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "定时任务图形数据回显类")
@CrmColumnResolve
public class JobChartInfoInfoRespVo {

    @ApiModelProperty("调度日期列表")
    private List<String> triggerDayList;

    @ApiModelProperty("进行中调度数量列表")
    private List<Integer> triggerDayCountRunningList;

    @ApiModelProperty("成功调度数量列表")
    private List<Integer> triggerDayCountSucList;

    @ApiModelProperty("失败调度数量列表")
    private List<Integer> triggerDayCountFailList;

    @ApiModelProperty("进行中调度总数")
    private Integer triggerCountRunningTotal;

    @ApiModelProperty("成功调度总数")
    private Integer triggerCountSucTotal;

    @ApiModelProperty("失败调度总数")
    private Integer triggerCountFailTotal;

}