package com.biz.crm.nebular.job.resp;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @ClassName: ScheduleJobReqVo
 * @Description: 定时任务配置入参Vo
 * @Author: Xiao
 * @Date: 2020/09/27
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "QrtzScheduleJobLogRespVo", description = "定时任务执行日志响应")
@SaturnEntity(name = "QrtzScheduleJobLogRespVo", description = "定时任务执行日志响应")
public class QrtzScheduleJobLogRespVo extends CrmBaseVo {

    /**
     * 任务名称
     */
    @ApiModelProperty("任务名称")
    @SaturnColumn(description = "任务名称")
    private String jobName;
    /**
     * 任务分组
     */
    @ApiModelProperty("任务分组")
    @SaturnColumn(description = "任务分组")
    private String jobGroup;

    /**
     * 指定执行类
     */
    @ApiModelProperty("指定执行类")
    @SaturnColumn(description = "指定执行类")
    private String jobClass;

    /**
     * 开始运行时间
     */
    @ApiModelProperty("开始运行时间")
    @SaturnColumn(description = "开始运行时间")
    private String runBeginTime;
    /**
     * 结束运行时间
     */
    @ApiModelProperty("结束运行时间")
    @SaturnColumn(description = "结束运行时间")
    private String runEndTime;
    /**
     * 运行结果
     */
    @ApiModelProperty("运行结果")
    @SaturnColumn(description = "运行结果")
    private String runStatus;
    /**
     * 运行日志
     */
    @ApiModelProperty("运行日志")
    @SaturnColumn(description = "运行日志")
    private String logContent;
//    /**
//     * 创建时间
//     */
//    @ApiModelProperty("记录时间")
//    @SaturnColumn(description = "记录时间")
//    private String createDate;
}
