package com.biz.crm.nebular.kms.acceptanceform.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 转换后验收单返回vo
 *
 * @author Gavin
 * @date 2021-05-12 18:03:22
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "转换后验收单")
public class KmsAcceptanceFormRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = 7612794000442550191L;
    @ApiModelProperty("租户ID")
    private String tenantryId;

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @ApiModelProperty("关联订货单（kms_order_form_detail_dw：orderNumber）")
    private String relateOrderNumber;

    @ApiModelProperty("关联原始订货单（kms_order_form_detail_dw：kaOrderNumber）")
    private String relateKaOrderNumber;

    /**
     * 直营体系Id
     */
    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("抓单生成的验收单编号")
    private String orderNumber;

    @ApiModelProperty("商超验收单编号")
    private String kaOrderNumber;

    @ApiModelProperty("单据来源")
    private String invoicesSource;

    @ApiModelProperty("验收单当前状态 枚举：kms_order_status")
    private String orderStatus;

    @ApiModelProperty("验收单当前状态描述")
    private String orderStatusMsg;

    @ApiModelProperty("商超编码")
    private String kaCode;

    @ApiModelProperty("商超名称")
    private String kaName;

    @ApiModelProperty("商超门店/大仓编号")
    private String kaStoreCode;

    @ApiModelProperty("商超门店/大仓名称")
    private String kaStoreName;

    /**
     * 关联ID(企业门店与商超门店表ID)
     */
    @ApiModelProperty("关联ID(企业门店与商超门店表ID)")
    private String storeRelatedId;

    @ApiModelProperty("企业门店/大仓编号")
    private String storeCode;

    @ApiModelProperty("企业门店/大仓名称")
    private String storeName;

    @ApiModelProperty("验收日期")
    private String acceptanceDate;

    @ApiModelProperty("稽核日期")
    private String auditDate;

    @ApiModelProperty("验收类型")
    private String acceptanceType;

    @ApiModelProperty("订货单总金额（含税）")
    private String finalOrderAmount;

    @ApiModelProperty("验收单总金额（含税）")
    private String finalAcceptanceAmount;

    @ApiModelProperty("订货单总金额（不含税）")
    private String finalOrderAmountNot;

    @ApiModelProperty("验收单总金额（不含税）")
    private String finalAcceptanceAmountNot;

    @ApiModelProperty("字段转换标识：0失败，1成功")
    private String transStatus;

    @ApiModelProperty("业务区域负责人")
    private String businessAreaLeader;

    @ApiModelProperty("业务区域")
    private String businessArea;

    @ApiModelProperty("区域编码")
    private String areaCode;

    @ApiModelProperty("区域名称")
    private String areaName;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("供应商名称")
    private String supplierName;

    @ApiModelProperty("供应商编码")
    private String supplierCode;

    @ApiModelProperty("登录账号")
    private String userName;

    @ApiModelProperty("企业产品编号")
    private String goodsCode;

    @ApiModelProperty("企业产品名称")
    private String goodsName;

    @ApiModelProperty("商超产品编号")
    private String kaGoodsCode;

    @ApiModelProperty("商超产品名称")
    private String kaGoodsName;

    @ApiModelProperty("验收单商品信息")
    private List<KmsAcceptanceGoodsRespVo> acceptanceGoodsVos;

    @ApiModelProperty("商超产品名称")
    private String acceptanceDateEnd;

    @ApiModelProperty("商超产品名称")
    private String acceptanceDateStart;

    @ApiModelProperty("所属公司")
    private String ownedCompany;
}