package com.biz.crm.nebular.kms.confadmin.base;

/**
 * <p>
 *  抓单单据及文件相关枚举类
 * </p>
 *
 * @author byran
 * @since 2019/12/16
 */
public class BaseFileConstants {

    private BaseFileConstants() {}

    /**
     * 单据及文件抓取方式
     */
    public enum DownloadWay {
        /**
         * 单线程
         */
        SINGLE_THREAD(0, "单线程"),
        /**
         * 多线程
         */
        MULTI_THREAD(1, "多线程"),
        ;

        private Integer value;
        private String description;

        DownloadWay(Integer value, String description) {
            this.value = value;
            this.description = description;
        }

        public Integer getValue() {
            return value;
        }

        public String getDescription() {
            return description;
        }
    }

    /**
     * 抓取文件类型
     */
    public enum FileClassify {
        /**
         * EXCEL
         */
        EXCEL(0, "EXCEL"),
        /**
         * PDF
         */
        PDF(1, "PDF"),
        /**
         * SCREEN_SHOT
         */
        SCREEN_SHOT(1, "SCREEN_SHOT"),
        ;

        private Integer value;
        private String description;

        FileClassify(Integer value, String description) {
            this.value = value;
            this.description = description;
        }

        public Integer getValue() {
            return value;
        }

        public String getDescription() {
            return description;
        }
    }
}
