package com.biz.crm.nebular.kms.confadmin.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.kms.confadmin.req
 * @ClassName TenantryDirectReqVo
 * @Author Gavin
 * @Date 2021/4/13 下午6:15
 * @Description 租户直营体系ReqVo
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "租户直营体系ReqVo")
public class TenantryDirectReqVo extends KmsBaseReqVo {
    private static final long serialVersionUID = 928474778859544516L;

    @ApiModelProperty(value = "商超ID")
    private String directId;

    @ApiModelProperty(value = "商超名称")
    private String directName;

    @ApiModelProperty(value = "直营系统Id")
    private String bsDirectSystemId;

    @ApiModelProperty(value = "直营系统编码")
    private String bsDirectSystemCode;

    @ApiModelProperty(value = "直营系统名称")
    private String bsDirectSystemName;

    @ApiModelProperty("商超门店编码")
    private String storeCode;

    @ApiModelProperty("商超门店名称")
    private String storeName;

    @ApiModelProperty("商超门店区域ID")
    private String areaId;

    @ApiModelProperty("单据类型编码")
    private String orderType;

    @ApiModelProperty("单据类型名称")
    private String orderTypeName;
}