package com.biz.crm.nebular.kms.confadmin.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.kms.confadmin.req
 * @ClassName TenantryDirectReqVo
 * @Author Gavin
 * @Date 2021/4/13 下午6:15
 * @Description 租户直营体系ReqVo
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "租户直营体系门店ReqVo")
public class TenantryDirectStoreReqVo extends KmsBaseReqVo {
    private static final long serialVersionUID = 928474778859544516L;

    @ApiModelProperty(value = "直营系统ID")
    private String bsDirectSystemId;

    /**
     * 商超ID（直营体系）
     */
    @ApiModelProperty(value = "商超ID")
    private String directId;

    /**
     * 搜索值
     */
    @ApiModelProperty(value = "搜索参数")
    private String searchValue;

    @ApiModelProperty("商超门店编码")
    private String storeCode;

    @ApiModelProperty("商超门店名称")
    private String storeName;

    @ApiModelProperty("商超门店区域ID")
    private String areaId;
}