package com.biz.crm.nebular.kms.confadmin.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * kms抓单接口参数返回vo
 *
 * @author Gavin
 * @date 2021-05-07 10:20:19
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "kms抓单接口参数")
public class KmsInterfaceParamRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = -5328518121343721046L;
    @ApiModelProperty("商超ID")
    private String directId;

    @ApiModelProperty("单据类型编码")
    private String orderType;

    @ApiModelProperty("参数属性名")
    private String fieldEn;

    @ApiModelProperty("参数文本名")
    private String fieldCn;

    @ApiModelProperty("控件类型")
    private String fieldClassify;

    @ApiModelProperty("参数类型")
    private String paramClassify;

    @ApiModelProperty("提示文字")
    private String promptText;

    @ApiModelProperty("字段是否必填(YES/NO)")
    private String isRequired;

    @ApiModelProperty("是否显示（0：显示，1：不显示）")
    private String isShow;

    @ApiModelProperty("字段排序")
    private Integer sortIndex;

    @ApiModelProperty("查询条件（0：不是筛选字段，1：是筛选字段）")
    private String isScreen;

    /**
     * 下拉单选或下拉多选选项列表
     */
    private List<KmsInterfaceParamOptionRespVo> options;

    /**
     * 子参数列表
     */
    private List<KmsInterfaceSubParamOptionRespVo> subOptions;
}