package com.biz.crm.nebular.kms.confadmin.resp;

import com.biz.crm.nebular.kms.confadmin.base.BaseFileConstants;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.kms.confadmin.resp
 * @ClassName TenantryDirectOrderTypeRespVo
 * @Author Gavin
 * @Date 2021/4/14 下午3:59
 * @Description 商超单据类型
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "商超单据类型RespVo")
public class TenantryDirectOrderTypeRespVo implements Serializable {
    private static final long serialVersionUID = 8556735932879469204L;

    /**
     * 唯一id
     */
    @ApiModelProperty("单据类型Id")
    private String orderTypeId;

    /**
     * 单据类型名称
     */
    @ApiModelProperty("单据类型名称")
    private String name;

    /**
     * 单据类型
     */
    @ApiModelProperty("单据类型编码")
    private String orderType;

    /**
     * 单据下载方式
     */
    @ApiModelProperty("单据下载方式")
    private BaseFileConstants.DownloadWay orderDownloadWay;

    /**
     * 原始文件格式
     */
    @ApiModelProperty("原始文件格式")
    private BaseFileConstants.FileClassify fileClassify;

    /**
     * 文件下载方式
     */
    @ApiModelProperty("文件下载方式")
    private BaseFileConstants.DownloadWay fileDownloadWay;
}