package com.biz.crm.nebular.kms.finance.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 稽核模板商超信息返回vo
 *
 * @author Gavin
 * @date 2021-05-25 17:56:09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "稽核模板商超信息")
public class KmsAuditTemplateDirectRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = -5561881225172648150L;
    @ApiModelProperty("稽核模版ID")
    private String auditTemplateId;

    @ApiModelProperty("商超ID")
    private String directId;

    @ApiModelProperty("商超名称")
    private String directName;

    @ApiModelProperty("容差规则（正_Z/负_F/上下浮动_UD）")
    private String auditRule;

    @ApiModelProperty("价格允差")
    private BigDecimal differencePrice;

    /**
     * 直营体系Id
     */
    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;


    /**
     * 直营体系编码
     */
    @ApiModelProperty("直营体系编码")
    private String bsDirectSystemCode;


    /**
     * 直营体系名称
     */
    @ApiModelProperty("直营体系名称")
    private String bsDirectSystemName;
}