package com.biz.crm.nebular.kms.kaproduct.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 企业产品与商超产品关系返回vo
 *
 * @author Gavin
 * @date 2021-04-15 14:28:52
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "企业产品与商超产品关系")
public class KmsTenantryDirectProductRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = 1335214925813612072L;

    @ApiModelProperty("商超Id")
    private String directId;

    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("直营体系编码")
    private String bsDirectSystemCode;

    @ApiModelProperty("直营体系名称")
    private String bsDirectSystemName;

    @ApiModelProperty("售达方编码")
    private String sellPartyCode;

    @ApiModelProperty("售达方名称")
    private String sellPartyName;

    @ApiModelProperty("企业产品编码")
    private String productCode;

    @ApiModelProperty("企业产品名称")
    private String productName;

    @ApiModelProperty("商超产品编码")
    private String kaProductCode;

    @ApiModelProperty("是否默认产品(Y/N)")
    private String isDefault;

    @ApiModelProperty("是否直营产品（Y/N）")
    private String isDirect;

    @ApiModelProperty("使用时间星期数枚举：")
    private String timeOfWeek;

    @ApiModelProperty("所属公司")
    private String ownedCompany;

    @ApiModelProperty("单位转换关系")
    private List<KmsProductUnitRespVo> unitReqVos;
}