package com.biz.crm.nebular.kms.orderform.resp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Project crm-core
 * @PackageName com.biz.crm.nebular.kms.orderform.resp
 * @ClassName WebServiceFindOrderItemRespVo
 * @Author Gavin
 * @Date 2021/10/22 下午4:01
 * @Description web service查询商超订货单商品明细
 */
@Data
public class WebServiceFindOrderItemRespVo implements Serializable {
    private static final long serialVersionUID = -5232968186239934232L;

    @ApiModelProperty("订单编号")
    private String orderNumber;

    @ApiModelProperty("商超订单编号")
    private String kaOrderNumber;

    @ApiModelProperty("企业产品编号")
    private String goodsCode;

    @ApiModelProperty("企业产品名称")
    private String goodsName;

    @ApiModelProperty("商超产品编号")
    private String kaGoodsCode;

    @ApiModelProperty("商超产品名称")
    private String kaGoodsName;

    @ApiModelProperty("产品国际条码")
    private String goodsBarCode;

    @ApiModelProperty("产品规格")
    private String specification;

    @ApiModelProperty("订货单价（含税）")
    private String unitPrice;

    @ApiModelProperty("订货金额小计（含税）")
    private String orderAmount;

    @ApiModelProperty("订货单价（不含税）")
    private String unitPriceNot;

    @ApiModelProperty("订货金额小计（不含税）")
    private String orderAmountNot;

    @ApiModelProperty("商超单位")
    private String curUnit;

    @ApiModelProperty("商超单位订货数量")
    private String curUnitOrderQuantity;

    @ApiModelProperty("企业单位")
    private String curCompanyUnit;

    @ApiModelProperty("企业单位订货数量")
    private String curCompanyUnitOrderQuantity;

    @ApiModelProperty("工厂编码")
    private String factoryCode;

    @ApiModelProperty("工厂名称")
    private String factoryName;

    @ApiModelProperty("产品税率")
    private String proRate;

    @ApiModelProperty("折扣")
    private String proRebate;


    @ApiModelProperty("维护单价")
    private String orderPrice;

    @ApiModelProperty("单价差异")
    private String priceDiff;

}