package com.biz.crm.nebular.kms.rawdata.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 原始订单头表请求vo
 *
 * @author Gavin
 * @date 2021-05-12 19:21:10
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsOrderFormDetailDwReqVo", description = "原始订单头表")
public class KmsOrderFormDetailDwReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = -6060944053591457312L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("租户ID")
    private String tenantryId;

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @ApiModelProperty("抓单生成的订单编号")
    private String orderNumber;

    @ApiModelProperty("订单版本号")
    private Integer versionNumber;

    @ApiModelProperty("商超订单编号")
    private String kaOrderNumber;

    @ApiModelProperty("订单当前状态")
    private String orderStatus;

    @ApiModelProperty("单据来源")
    private String invoicesSource;

    @ApiModelProperty("商超编码")
    private String kaCode;

    @ApiModelProperty("商超名称")
    private String kaName;

    @ApiModelProperty("订单日期")
    private String orderDate;

    @ApiModelProperty("交货日期")
    private String deliveryDate;

    @ApiModelProperty("经营方式")
    private String runMode;

    @ApiModelProperty("订货单总金额（含税）")
    private String finalOrderAmount;

    @ApiModelProperty("订货单总金额（不含税）")
    private String finalOrderAmountNot;

    @ApiModelProperty("商超门店/大仓编号")
    private String kaStoreCode;

    @ApiModelProperty("商超门店/大仓名称")
    private String kaStoreName;

    @ApiModelProperty("企业门店/大仓编号")
    private String storeCode;

    @ApiModelProperty("企业门店/大仓名称")
    private String storeName;

    @ApiModelProperty("送货地址")
    private String deliveryAddress;

    @ApiModelProperty("送货联系人")
    private String deliveryContact;

    @ApiModelProperty("送货联系人电话")
    private String deliveryContactPhone;

    @ApiModelProperty("业务区域负责人")
    private String businessAreaLeader;

    @ApiModelProperty("业务区域")
    private String businessArea;

    @ApiModelProperty("区域编码")
    private String areaCode;

    @ApiModelProperty("区域名称")
    private String areaName;

    @ApiModelProperty("订单审批单号")
    private String orderApprovalNumber;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("SKU最大单位数量汇总")
    private String maxUnitSum;

    @ApiModelProperty("字段转换标识：0未转换，1已转换")
    private String transStatus;
}