package com.biz.crm.nebular.kms.returnform.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
/**
 * 退货单信息表请求vo
 *
 * @author Gavin
 * @date 2021-05-12 18:23:07
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsReturnFormReqVo", description = "退货单信息表")
public class KmsReturnFormReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = 8010307855637372488L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("租户ID")
    private String tenantryId;

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @ApiModelProperty("抓单生成的退货单编号")
    private String orderNumber;

    @ApiModelProperty("订单版本号")
    private Integer versionNumber;

    @ApiModelProperty("退货单当前状态 枚举：kms_order_status")
    private String orderStatus;

    @ApiModelProperty("商超退货单编号")
    private String kaOrderNumber;

    @ApiModelProperty("单据来源")
    private String invoicesSource;

    @ApiModelProperty("关联客户订单")
    private String relateCustomOrder;

    @ApiModelProperty("商超编码")
    private String kaCode;

    @ApiModelProperty("商超名称")
    private String kaName;

    @ApiModelProperty("商超门店/大仓编号")
    private String kaStoreCode;

    @ApiModelProperty("商超门店/大仓名称")
    private String kaStoreName;

    /**
     * 关联ID(企业门店与商超门店表ID)
     */
    @ApiModelProperty("关联ID(企业门店与商超门店表ID)")
    private String storeRelatedId;

    @ApiModelProperty("企业门店/大仓编号")
    private String storeCode;

    @ApiModelProperty("企业门店/大仓名称")
    private String storeName;

    @ApiModelProperty("单据日期")
    private String orderDate;

    @ApiModelProperty("单据日期开始时间")
    private String orderDateStart;

    @ApiModelProperty("单据日期结束时间")
    private String orderDateEnd;

    @ApiModelProperty("退货原因")
    private String returnReason;

    @ApiModelProperty("退货订单总金额（含税）")
    private String finalReturnAmount;

    @ApiModelProperty("退货订单总金额（不含税）")
    private String finalReturnAmountNot;

    @ApiModelProperty("SKU最大单位数量汇总")
    private String maxUnitSum;

    @ApiModelProperty("字段转换标识：0失败，1成功")
    private String transStatus;

    @ApiModelProperty("业务区域负责人")
    private String businessAreaLeader;

    @ApiModelProperty("业务区域")
    private String businessArea;

    @ApiModelProperty("区域编码")
    private String areaCode;

    @ApiModelProperty("区域名称")
    private String areaName;

    @ApiModelProperty("订单审批单号")
    private String orderApprovalNumber;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("供应商名称")
    private String supplierName;

    @ApiModelProperty("供应商编码")
    private String supplierCode;

    @ApiModelProperty("登录账号")
    private String userName;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("退货金额（含税）")
    private String returnAmount;

    @ApiModelProperty("公司组织编码")
    private String companyOrgCode;

    @ApiModelProperty("组织编码集合")
    private List<String> orgCodes;
}