package com.biz.crm.nebular.kms.salesdata.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 销售数据表请求vo
 *
 * @author gavin
 * @date 2021-11-24 14:22:40
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsSalesDataReqVo", description = "销售数据表")
public class KmsSalesDataReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = 5562453120564312985L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("租户ID")
    private String tenantryId;

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @ApiModelProperty("企业销售数据编号")
    private String orderNumber;

    @ApiModelProperty("版本号")
    private Integer versionNumber;

    @ApiModelProperty("商超单据编号")
    private String kaOrderNumber;

    @ApiModelProperty("单据来源")
    private String invoicesSource;

    @ApiModelProperty("商超编码")
    private String kaCode;

    @ApiModelProperty("商超名称")
    private String kaName;

    @ApiModelProperty("销售日期")
    private String salesDate;

    @ApiModelProperty("销售日期开始;格式[yyyy-MM-dd]")
    private String salesDateStart;

    @ApiModelProperty("销售日期结束;格式[yyyy-MM-dd]")
    private String salesDateEnd;

    @ApiModelProperty("商超门店/大仓编号")
    private String kaStoreCode;

    @ApiModelProperty("商超门店/大仓名称")
    private String kaStoreName;

    @ApiModelProperty("企业门店/大仓编号")
    private String storeCode;

    @ApiModelProperty("企业门店/大仓名称")
    private String storeName;

    @ApiModelProperty("企业产品编号")
    private String goodsCode;

    @ApiModelProperty("企业产品名称")
    private String goodsName;

    @ApiModelProperty("商超产品编号")
    private String kaGoodsCode;

    @ApiModelProperty("商超产品名称")
    private String kaGoodsName;

    @ApiModelProperty("产品国际条码")
    private String goodsBarCode;

    @ApiModelProperty("产品规格")
    private String specification;

    @ApiModelProperty("销售成本")
    private String salesCost;

    @ApiModelProperty("销售金额")
    private String salesAmount;

    @ApiModelProperty("经营方式")
    private String runMode;

    @ApiModelProperty("门店所属大区编号")
    private String areaCode;

    @ApiModelProperty("门店所属大区名称")
    private String areaName;

    @ApiModelProperty("竞品品牌")
    private String competitiveBrands;

    @ApiModelProperty("商超当前单位层级")
    private String curUnitLevel;

    @ApiModelProperty("商超当前单位")
    private String curUnit;

    @ApiModelProperty("商超当前单位销售数量")
    private String curUnitSalesQuantity;

    @ApiModelProperty("商超最小单位层级")
    private String minUnitLevel;

    @ApiModelProperty("商超最小单位")
    private String minUnit;

    @ApiModelProperty("商超最小单位销售数量")
    private String minUnitSalesQuantity;

    @ApiModelProperty("商超最大单位层级")
    private String maxUnitLevel;

    @ApiModelProperty("商超最大单位")
    private String maxUnit;

    @ApiModelProperty("商超最大单位销售数量")
    private String maxUnitSalesQuantity;

    @ApiModelProperty("业务区域")
    private String businessArea;

    @ApiModelProperty("登录账号")
    private String userName;

    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("单据当前状态")
    private String orderStatus;

    @ApiModelProperty("单据当前状态信息")
    private String orderStatusMsg;

    @ApiModelProperty("关联ID(企业商品与商超商品表ID)")
    private String goodsRelatedId;

    @ApiModelProperty("企业当前销售单位")
    private String curCompanyUnit;

    @ApiModelProperty("企业当前单位销售数量")
    private String curCompanyUnitOrderQuantity;

}