package com.biz.crm.nebular.kms.sap.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * SAP数据返回vo
 *
 * @author Gavin
 * @date 2021-05-27 14:34:14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SAP数据")
public class KmsSapOrderFormRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = 953026761253632799L;

    @ApiModelProperty("稽核ID")
    private String auditId;

    @ApiModelProperty("sap单据编码")
    private String sapNo;

    @ApiModelProperty("交货单号")
    private String vgbel;

    @ApiModelProperty("sap过账日期")
    private String sapPostingDate;

    @ApiModelProperty("送达方编号")
    private String storeCode;

    @ApiModelProperty("送达方名称")
    private String storeName;

    @ApiModelProperty("SAP物料号")
    private String sapMaterielCode;

    @ApiModelProperty("SAP物料名称")
    private String sapMaterielName;

    @ApiModelProperty("商品类型")
    private String productType;

    @ApiModelProperty("SAP数量")
    private BigDecimal sapQuantity;

    @ApiModelProperty("SAP总金额（不含税）")
    private BigDecimal sapAmountNot;

    @ApiModelProperty("SAP总金额（含税）")
    private BigDecimal sapAmount;

    @ApiModelProperty("配送商")
    private String distributor;

    @ApiModelProperty("匹配模版ID集合(用于判断当前规则是否汇总当前数据)")
    private String auditTemplateId;

    @ApiModelProperty("送达方编码")
    private String kunnr;

    @ApiModelProperty("送达方名称")
    private String kunnrname;

    @ApiModelProperty("售达方编码")
    private String kunag;

    @ApiModelProperty("售达方名称")
    private String kunagname;

    @ApiModelProperty("发票净值")
    private BigDecimal netwr;

    @ApiModelProperty("发票税额")
    private BigDecimal mwsbp;

    @ApiModelProperty("含税总价")
    private BigDecimal kzwi1;

    @ApiModelProperty("税率")
    private BigDecimal mwsi1;

    @ApiModelProperty("返利")
    private BigDecimal kzwi4;

    @ApiModelProperty("折扣")
    private BigDecimal yk99;

    @ApiModelProperty("物料数量价格折扣 (PR)")
    private BigDecimal yk04;

    @ApiModelProperty("即时返点%产品组折扣(PR)")
    private BigDecimal yk11;

    @ApiModelProperty("赠品分摊折扣")
    private BigDecimal zst2;

    @ApiModelProperty("含税单价")
    private BigDecimal danjia;

    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private String taxRate;

    @ApiModelProperty("业务员编码")
    private String pernr;

    @ApiModelProperty("业务员描述")
    private String name4;

    @ApiModelProperty("sap创建时间")
    private String erzet;

    @ApiModelProperty("sap订单号")
    private String aubel;

    @ApiModelProperty("sap订单创建时间")
    private String vbakerdat;
}