package com.biz.crm.nebular.kms.supermarket.req;

import java.util.List;

import com.biz.crm.nebular.mdm.CrmExtTenVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 售达方与供应商关系表请求vo
 *
 * @author gavin
 * @date 2021-07-06 13:58:17
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "KmsSupplierReqVo", description = "售达方与供应商关系表")
public class KmsSupplierReqVo extends CrmExtTenVo {

    private static final long serialVersionUID = 6356037902596955407L;
    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("直营体系Id集合")
    private List<String> bsDirectSystemIdList;

    @ApiModelProperty("直营体系编码")
    private String bsDirectSystemCode;

    @ApiModelProperty("直营体系名称")
    private String bsDirectSystemName;

    @ApiModelProperty("售达方Id")
    private String sellPartyId;

    @ApiModelProperty("售达方编码")
    private String sellPartyCode;

    @ApiModelProperty("售达方名称")
    private String sellPartyName;

    @ApiModelProperty("供应商编码")
    private String supplierCode;

    @ApiModelProperty("供应商编码集合")
    private List<String> supplierCodes;

}