package com.biz.crm.nebular.kms.supermarket.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 客户组织与抓单商超（直营体系）关系表返回vo
 *
 * @author Gavin
 * @date 2021-04-13 17:05:17
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户组织与抓单商超（直营体系）关系表")
@CrmColumnResolve
public class KmsTenantryDirectCustomerOrgRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = -8902950175256181910L;
    @ApiModelProperty("商超ID")
    private String directId;

    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("直营体系编码")
    private String bsDirectSystemCode;

    @ApiModelProperty("直营体系名称")
    private String bsDirectSystemName;

    @ApiModelProperty("客户组织ID")
    private String customerOrgId;

    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织名称")
    private String customerOrgName;

    @ApiModelProperty("所属公司")
    private String ownedCompany;

    @ApiModelProperty("订单推送SAP时间计算阈值")
    private Integer timeOfDay;
}