package com.biz.crm.nebular.kms.supermarket.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 企业门店与商超门店关系返回vo
 *
 * @author Gavin
 * @date 2021-04-15 11:31:07
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "企业门店与商超门店关系")
public class KmsTenantryDirectStoreRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = -2555693710399077931L;

    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("直营体系编码")
    private String bsDirectSystemCode;

    @ApiModelProperty("商超id")
    private String directId;

    @ApiModelProperty("直营体系名称")
    private String bsDirectSystemName;

    @ApiModelProperty("企业门店编码")
    private String terminalCode;

    @ApiModelProperty("企业门店名称")
    private String terminalName;

    @ApiModelProperty("商超门店Id")
    private String storeId;

    @ApiModelProperty("商超门店编码")
    private String storeCode;

    @ApiModelProperty("商超门店名称")
    private String storeName;

    /**
     * 门店区域编码
     */
    @ApiModelProperty("商超门店区域编码")
    private String areaCode;

    /**
     * 门店区域名称
     */
    @ApiModelProperty("商超门店区域名称")
    private String areaName;

    /**
     * 对账匹配阈值（天数）
     * 匹配门店时对时间进行处理
     */
    @ApiModelProperty("对账匹配阈值（天数）")
    private Integer timeOfDay;

    @ApiModelProperty("所属公司")
    private String ownedCompany;
}