package com.biz.crm.nebular.kms.supermarket.resp;

import com.biz.crm.nebular.kms.kaproduct.resp.KmsTenantryDirectProductRespVo;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 总仓门店返回vo
 *
 * @author lf
 * @date 2021-06-26 11:20:06
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "总仓门店")
public class KmsTotalWarehouseStoreRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = -665747861922738248L;
    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("直营体系编码")
    private String bsDirectSystemCode;

    @ApiModelProperty("直营体系名称")
    private String bsDirectSystemName;

    @ApiModelProperty("产品类型-数据字典：kms_product_type")
    private String productType;

    @ApiModelProperty("产品类型描述")
    private String productTypeDesc;

    @ApiModelProperty("直营门店ID")
    private String directStoreId;

    @ApiModelProperty("送达方编码-取企业门店编码")
    private String terminalCode;

    @ApiModelProperty("送达方名称-取企业门店名称")
    private String terminalName;

    @ApiModelProperty("上架产品ID")
    private String directProductId;

    @ApiModelProperty("上架产品")
    private List<KmsTenantryDirectProductRespVo> directProductReqVos;

    /**
     * 上架产品编码
     */
    @ApiModelProperty("商超产品编码")
    private String kaProductCode;

    /**
     * 企业产品编码
     */
    @ApiModelProperty("企业产品编码")
    private String productCode;

    /**
     * 企业产品名称
     */
    @ApiModelProperty("企业产品名称")
    private String productName;

    @ApiModelProperty("所属公司")
    private String ownedCompany;
}