package com.biz.crm.nebular.mdm.availablelist;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.config.CrmDict;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;

/**
 * 可购清单导入vo
 * @Author: chenrong
 * @Date: 2021/4/1 11:26
 */
@Data
public class CusAvailableListImportVo extends AbstractImportVo {

  @ColumnWidth(value = 20)
  @ExcelProperty(value = "客户编码")
  private String cusCode;

  @ColumnWidth(value = 20)
  @ExcelProperty(value = "客户名称")
  private String cusName;

  @ColumnWidth(value = 20)
  @ExcelProperty(value = "客户所属组织编码")
  private String cusOrgCode;

  @ColumnWidth(value = 20)
  @ExcelProperty(value = "客户所属组织名称")
  private String cusOrgName;

  @ColumnWidth(value = 20)
  @ExcelProperty(value = "客户所属渠道编码")
  private String cusChannelCode;

  @ColumnWidth(value = 20)
  @ExcelProperty(value = "客户所属渠道名称")
  @CrmDict(typeCode="channel",dictCodeField="cusChannelCode")
  private String cusChannelName;

  @ColumnWidth(value = 20)
  @ExcelProperty(value = "是否常购")
  private Integer ofenFlag;

  @ColumnWidth(value = 20)
  @ExcelProperty(value = "商品编码")
  private String productCode;

  @ColumnWidth(value = 20)
  @ExcelProperty(value = "商品名称")
  private String productName;

}
