package com.biz.crm.nebular.mdm.availablelist;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/10/13 11:24
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "客户可够清单的vo")
@SaturnEntity(name = "TerminalAvailablelistVo", description = "客户可够清单信息")
public class TerminalAvailablelistVo extends MdmProductAdviseRespVo {


    @ApiModelProperty(value = "终端编码")
    @SaturnColumn(description = "终端编码")
    private String terminalCode;

    @ApiModelProperty(value = "终端名称")
    @SaturnColumn(description = "终端名称")
    private String terminalName;

    @ApiModelProperty(value = "终端所属组织编码")
    @SaturnColumn(description = "终端所属组织编码")
    private String terminalOrgCode;

    @ApiModelProperty(value = "终端所属组织名称")
    @SaturnColumn(description = "终端所属组织名称")
    private String terminalOrgName;

    @ApiModelProperty(value = "终端所属渠道编码")
    @SaturnColumn(description = "终端所属渠道编码")
    private String terminalChannelCode;

    @ApiModelProperty(value = "终端所属渠道名称")
    @SaturnColumn(description = "终端所属渠道名称")
    @CrmDict(typeCode = "channel", dictCodeField = "terminalChannelCode")
    private String terminalChannelName;
    /**
     * 终端信息（拓展用）
     */
    private MdmTerminalVo mdmTerminalVo;
}
