package com.biz.crm.nebular.mdm.constant;

/**
 * 字典常量
 *
 * @author zxw
 */
public interface DictConstant {
    /**
     * Excel导入配置
     */
    String EXCEL_IMPORT_CONFIG = "excel_import_config";
    /**
     * 销售公司
     */
    String SALE_COMPANY = "sale_company";

    /**
     * 客户组织层级
     */
    String CUS_ORG_LEVEL = "cus_org_level";

    /**
     * 客户组织类型
     */
    String CUS_ORG_TYPE = "cus_org_type";

    /**
     * 用户类型：u用户，c客户用户
     */
    String USER_TYPE = "user_type";

    /**
     * 操作类型n新建职位，h已有职位
     */
    String POSITION_OPERATION = "position_operation";

    /**
     * 主职位，y是n否
     */
    String POSITION_PRIMARY = "position_primary";

    /**
     * 权限对象
     */
    String PERMISSION_OBJ = "permission_obj";

    /**
     * 权限对象：职位
     */
    String PERMISSION_OBJ_POSITION = "permission_obj_position";

    /**
     * 价格截断控制
     */
    String PRICE_TRUNCATION = "price_truncation";

    /**
     * 权限对象：组织
     */
    String PERMISSION_OBJ_ORG = "permission_obj_org";

    /**
     * 权限维度
     */
    String PERMISSION_DIMENSION = "permission_dimension";

    /**
     * 数据来源
     */
    String PERMISSION_RESOURCE = "permission_resource";

    /**
     * 组织类型
     */
    String MDM_ORG_TYPE = "mdm_org_type";

    /**
     * 行政区域层级
     */
    String REGION_LEVEL = "region_level";

    /**
     * 物料基本单位
     **/
    String MATERIAL_BASE_UNIT = "material_base_unit";
    /**
     * 销售单位
     **/
    String MATERIAL_SALE_UNIT = "material_sale_unit";

    /**
     * 锁定状态
     * 003:锁定; 009:正常
     **/
    String LOCK_STATE = "lock_state";

    /**
     * 菜单模块
     */
    String FUNCTION_MODULE = "function_module";

    /**
     * 菜单类型
     */
    String FUNCTION_CONFIG = "function_config";

    /**
     * 渠道
     */
    String CHANNEL = "channel";

    /**
     * 终端类型
     */
    String TERMINAL_TYPE = "terminal_type";

    /**
     * 陈列类型
     */
    String DISPLAY_TYPE = "display_type";

    /**
     * 方案活动 兑付方式
     */
    String PAYMENT_METHOD = "payment_method";

    /**
     * 图标类型
     */
    String ICON_TYPE = "icon_type";
    /**
     * 按钮类型
     */
    String BUTTON_TYPE = "button_type";

    /**
     * 费用扣减、红冲排序规则
     */
    String FEE_POOL_REDUCE_RED_TRICK_RULE = "fee_reduce_redtrick_rule";

    /***
     * 货补费用池当前使用的价格类型（只能包含一条字典记录）
     */
    String REP_FEE_PRICE_TYPE_USING = "rep_fee_price_type_using";

    /**
     * 价格类型，用于或不费用上账、调整时查询价格
     */
    String PRICE_SEARCH_TYPE = "price_search_type";

    /**
     * 条件字段
     */
    String PRICE_CONDITION = "price_condition";

    /**
     * 是否1是0否
     */
    String YES_OR_NO = "yes_or_no";

    /**
     * 商品基本单位
     */
    String PRODUCT_BASE_UNIT = "product_base_unit";

    /**
     * 商品销售单位
     */
    String PRODUCT_SALE_UNIT = "product_sale_unit";

    /**
     * 性别
     */
    String GENDER = "gender";

    /**
     * 模块分组
     */
    String MODULE_GROUP = "module_group";

    /**
     * 客户显隐控制
     */
    String CUSTOMER_ADD_SECTION = "customer_add_section";
    String CUSTOMER_ADD_SECTION_SALES_AREA = "sales_area";
    String CUSTOMER_ADD_SECTION_CONTACT_INFORMATION = "contact_information";
    String CUSTOMER_ADD_SECTION_EXTENDED_INFORMATION = "extended_information";
    String CUSTOMER_ADD_SECTION_EXTENDED_PRODUCT_INFORMATION = "extended_information_product";
    String CUSTOMER_ADD_SECTION_BILL = "customer_bill";

    /**
     * 终端显隐控制
     */
    String TERMINAL_ADD_SECTION = "terminal_add_section";
    String TERMINAL_ADD_SECTION_ONTACT_INFORMATION = "contact_information";
    String TERMINAL_ADD_SECTION_SUPPLY_RELATIONSHIP = "supply_relationship";
    String TERMINAL_ADD_SECTION_SUPPLY_RELATIONSHIP_PRODUCT = "supply_relationship_product";

    /***费用池分组*/
    String FEE_POOL_GROUP = "fee_pool_group";
    /***费用池类型*/
    String FEE_POOL_TYPE = "fee_pool_type";
    /***费用池类型-扩展字段-支付方式*/
    String FEE_POOL_TYPE_EXTEND_PAY_TYPE = "pay_type";
    /***费用池操作类型*/
    String FEE_POOL_OPERATION_TYPE = "fee_pool_operation_type";
    /***费用池操作类型分组*/
    String FEE_POOL_OPERATION_TYPE_GROUP = "fee_pool_operation_type_group";
    /***费用池操作类型-扩展字段-操作类型分组*/
    String FEE_POOL_OPERATION_TYPE_EXTEND_OPERATION_GROUP = "operation_group";
    /***费用池支付方式*/
    String FEE_POOL_PAY_TYPE = "fee_pool_pay_type";
    /***费用使用类型*/
    String FEE_POOL_USE_TYPE = "fee_pool_use_type";
    /***费用池列表配置*/
    String FEE_POOL_PAGE_LIST_CONFIG = "fee_pool_page_list_config";
    /***费用池列表配置-扩展字段-费用池分组*/
    String FEE_POOL_PAGE_LIST_CONFIG_EXTEND_POOL_GROUP = "pool_group";
    /***费用池列表配置-扩展字段-费用类型*/
    String FEE_POOL_PAGE_LIST_CONFIG_EXTEND_POOL_TYPE = "pool_type";
    /***费用池列表配置-扩展字段-使用类型*/
    String FEE_POOL_PAGE_LIST_CONFIG_EXTEND_USE_TYPE = "use_type";
    /***费用池列表配置-扩展字段-列表查询操作类型*/
    String FEE_POOL_PAGE_LIST_CONFIG_EXTEND_QUERY_OPERATION_TYPE = "query_operation_type";
    /***费用池列表配置-扩展字段-列表头上账操作类型*/
    String FEE_POOL_PAGE_LIST_CONFIG_EXTEND_ACCOUNT_OPERATION_TYPE = "account_operation_type";
    /***费用池列表配置-扩展字段-行调整操作类型*/
    String FEE_POOL_PAGE_LIST_CONFIG_EXTEND_ADJUST_OPERATION_TYPE = "adjust_operation_type";
    /***费用池列表配置-扩展字段-行详情调整配置编码*/
    String FEE_POOL_PAGE_LIST_CONFIG_EXTEND_LINE_DETAIL_ADJUST_CONFIG_CODE = "line_detail_adjust_config_code";

    /***登录类型控制*/
    String LOGIN_CONTROL_CONFIG = "login_control_config";

    /***短信模板*/
    String MESSAGE_TEMPLATE = "message_template";
    /***短信模板-登录模板*/
    String MESSAGE_TEMPLATE_SYSTEM_LOGIN = "system_login";
    /***短信模板-登录并且重置模板*/
    String MESSAGE_TEMPLATE_SYSTEM_LOGIN_AND_RESET = "system_login_and_reset";

    /**
     * 是否价格截断
     */
    String PRICE_CHUNK_CONFIG = "price_chunk_config";

    /***从sfa新增终端字段重复性校验*/
    String MDM_UNIQUE_CHECK_TERMINAL_ADD_FROM_SFA = "mdm_unique_check_terminal_add_from_sfa";

    String MDM_AMAP_POI_CITY = "mdm_amap_poi_city";

    String MDM_AMAP_POI_KEYWORD = "mdm_amap_poi_keyword";
    
    String MDM_AMAP_POI_TYPE = "mdm_amap_poi_type";

    /**
     * 陈列位置
     */
    String DISPLAY_PLACE = "display_place";

    /**
     * 是否合格
     */
    String IS_QUALIFIED = "is_qualified";

    String CUSTOMER_TYPE = "customer_type";

    /**
     * tpm销售计划类型
     * */
    String SALES_PLAN_TYPE = "sales_plan_type";

}
