package com.biz.crm.nebular.mdm.constant;

/**
 * 行政区域层级枚举
 */
public enum RegionLevelEnum {

    COUNTRY("0", null, "国家"),
    PROVINCE("1", "0", "省、自治区、直辖市、特别行政区"),
    CITY("2", "1", "市"),
    COUNTY("3", "2", "区、县"),
    TOWNSHIP("4", "3", "乡、镇");

    RegionLevelEnum(String code, String parentCode, String desc) {
        this.code = code;
        this.parentCode = parentCode;
        this.desc = desc;
    }

    public static String getParentRegionLevel(String regionLevel) {
        for (RegionLevelEnum item :
                RegionLevelEnum.values()) {
            if (item.getCode().equals(regionLevel)) {
                return item.getParentCode();
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getParentCode() {
        return parentCode;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 行政区域级别
     */
    private String code;
    /**
     * 上级行政区域级别
     */
    private String parentCode;
    /**
     * 描述
     */
    private String desc;

}
