package com.biz.crm.nebular.mdm.cusorg;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author zxw
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "客户组织下拉框响应")
public class MdmCustomerOrgSelectRespVo {

    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty(value = "客户组织名称")
    private String customerOrgName;

    @ApiModelProperty("客户组织层级")
    private String customerOrgLevel;

    @ApiModelProperty("客户组织类型")
    private String customerOrgType;

    @ApiModelProperty(value = "客户组织编码/客户组织名称")
    private String unionName;

    public String getUnionName() {
        return (customerOrgCode == null ? "" : customerOrgCode) + "/" + (customerOrgName == null ? "" : customerOrgName);
    }

}
