package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 客户供货关系明细返回vo
 *
 * @author zxw
 * @date 2020-12-16 14:28:18
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户供货关系明细")
@SaturnEntity(name = "MdmCustomerSupplyDetailRespVo", description = "客户供货关系明细")
public class MdmCustomerSupplyDetailRespVo extends CrmExtTenVo {

    @ApiModelProperty("类型1商品2产品层级")
    @SaturnColumn(description = "类型1商品2产品层级")
    private String dataType;

    @ApiModelProperty("编码")
    @SaturnColumn(description = "编码")
    private String code;

    @ApiModelProperty("描述")
    @SaturnColumn(description = "描述")
    private String name;

    @ApiModelProperty("供货关系id")
    @SaturnColumn(description = "供货关系id")
    private String supplyId;

}