package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 请求vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "MdmCustomerTerminalReqVo", description = "客户终端查询入参")
public class MdmCustomerTerminalReqVo extends PageVo {


    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("1：未关联任何用户的终端，2：未关联当前客户的终端，3:关联当前客户的终端")
    private Integer queryType;

    @ApiModelProperty("终端编码或名称")
    private String terminalNameOrCode;

    @ApiModelProperty("终端类型")
    private String terminalType;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    private List<String> terminalCodeList;

    @ApiModelProperty("省编码")
    private String provinceCode;
    @ApiModelProperty("市编码")
    private String cityCode;
    @ApiModelProperty("区编码")
    private String districtCode;
    @ApiModelProperty("省名称")
    private String provinceName;
    @ApiModelProperty("市名称")
    private String cityName;
    @ApiModelProperty("区名称")
    private String districtName;
}