package com.biz.crm.nebular.mdm.employeedirectory;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 员工通讯录信息响应vo
 * @author yangshan
 * @date 2021-3-5 14:46:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmEmployeeDirectoryListRespVo", description = "员工通讯录信息")
public class MdmEmployeeDirectoryListRespVo{


    /**
     * 姓氏首字母
     */
    @ApiModelProperty("姓氏首字母")
    private String firstNameInitials;

    /**
     * 姓氏首字母对应人员信息
     */
    @ApiModelProperty("姓氏首字母对应人员信息")
    private List<MdmEmployeeDirectoryRespVo> respVos;


    public MdmEmployeeDirectoryListRespVo() {
    }
    public MdmEmployeeDirectoryListRespVo(String firstNameInitials, List<MdmEmployeeDirectoryRespVo> respVos) {
        this.firstNameInitials = firstNameInitials;
        this.respVos = respVos;
    }

}
