package com.biz.crm.nebular.mdm.enums;

import com.biz.crm.util.StringUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Optional;

/**
 * @author zxw
 */

@Getter
@AllArgsConstructor
public enum CustomerDefaultAddressEnum {

    /**
     * 是否是客户默认收货地址
     */
    N("0","否"),
    Y("1", "是");

    private final String code;

    private final String value;

    public static String getVal(String code) {
        if (!StringUtils.isEmpty(code)) {
            CustomerDefaultAddressEnum[] values = CustomerDefaultAddressEnum.values();
            for (CustomerDefaultAddressEnum value : values) {
                if (value.code.equals(code)) {
                    return value.value;
                }
            }
        }
        return null;
    }
}
