package com.biz.crm.nebular.mdm.function;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.button.MdmButtonRespVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 菜单表返回vo
 *
 * @author zxw
 * @date 2020-11-18 10:26:31
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "菜单及按钮树")
@SaturnEntity(name = "MdmFunctionRespVo", description = "菜单及按钮树")
public class MdmFunctionButtonRespVo extends CrmExtTenVo {

    @ApiModelProperty("菜单编码")
    @SaturnColumn(description = "菜单编码")
    private String functionCode;

    @ApiModelProperty("菜单名称")
    @SaturnColumn(description = "菜单名称")
    private String functionName;

    @ApiModelProperty("菜单排序")
    @SaturnColumn(description = "菜单排序")
    private String functionOrder;

    @ApiModelProperty("菜单地址")
    @SaturnColumn(description = "菜单地址")
    private String functionUrl;

    @ApiModelProperty("上级菜单编码")
    @SaturnColumn(description = "上级菜单编码")
    private String parentCode;

    @ApiModelProperty("图标")
    @SaturnColumn(description = "图标")
    private String functionIcon;

    @ApiModelProperty("所属模块:1：mdm，2：dms，3：tpm，4：sfa(数据字典：function_module)")
    @SaturnColumn(description = "所属模块:1：mdm，2：dms，3：tpm，4：sfa")
    private String functionModule;

    @ApiModelProperty("所属模块名称")
    @CrmDict(typeCode = DictConstant.FUNCTION_MODULE,dictCodeField = "functionModule")
    private String functionModuleName;

    @ApiModelProperty("菜单类型:0：系统菜单，1：dms商城，2：dms小程序，3:sfa小程序，4：sfaapp(数据字典：function_config)")
    @SaturnColumn(description = "菜单类型:0：系统菜单，1：dms商城，2：dms小程序，3:sfa小程序，4：sfaapp")
    private String functionConfig;

    @ApiModelProperty("菜单类型名称")
    @CrmDict(typeCode = DictConstant.FUNCTION_CONFIG,dictCodeField = "functionConfig")
    private String functionConfigName;

    @ApiModelProperty("是否选中：1是，0否")
    private String select;

    @ApiModelProperty("按钮列表")
    private List<MdmButtonRespVo> mdmButtonVos;

    @ApiModelProperty("下级菜单树")
    private List<MdmFunctionButtonRespVo> children;

}