package com.biz.crm.nebular.mdm.kms.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author zxw
 */
@ApiModel(value = "普通单据")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class KmsIndentVoucherVo {
    /**
     * 企业订货单编号
     */
    @ApiModelProperty(value = "企业订货单编号")
    private String orderNumber;

    /**
     * 商超订单编号
     */
    @ApiModelProperty(value = "商超订单编号")
    private String kaOrderNumber;

    /**
     * 订货审批编号
     */
    @ApiModelProperty(value = "订货审批编号")
    private String orderApprovalNumber;

    /**
     * 单据审批
     */
    @ApiModelProperty(value = "单据审批")
    private String processStateDes;

    /**
     * 商超编号
     */
    @ApiModelProperty(value = "商超编号")
    private String kaCode;

    /**
     * 商超门店/大仓编号
     */
    @ApiModelProperty(value = "商超门店/大仓编号")
    private String kaStoreCode;

    /**
     * 商超门店/大仓名称
     */
    @ApiModelProperty(value = "商超门店/大仓名称")
    private String kaStoreName;

    /**
     * 企业门店/大仓编号
     */
    @ApiModelProperty(value = "企业门店/大仓编号")
    private String storeCode;

    /**
     * 企业门店/大仓名称
     */
    @ApiModelProperty(value = "企业门店/大仓名称")
    private String storeName;

    /**
     * 单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)
     */
    @ApiModelProperty(value = "单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)")
    private String invoicesSource;

    /**
     * 经营方式
     */
    @ApiModelProperty(value = "经营方式")
    private String runMode;

    /**
     * 送货联系人
     */
    @ApiModelProperty(value = "送货联系人")
    private String deliveryContact;

    /**
     * 送货地址
     */
    @ApiModelProperty(value = "送货地址")
    private String deliveryAddress;

    /**
     * 送货联系电话
     */
    @ApiModelProperty(value = "送货联系电话")
    private String deliveryContactPhone;

    /**
     * 业务区域
     */
    @ApiModelProperty(value = "业务区域")
    private String businessArea;

    /**
     * 业务区域负责人
     */
    @ApiModelProperty(value = "业务区域负责人")
    private String businessAreaLeader;

    /**
     * SKU数量汇总
     */
    @ApiModelProperty(value = "SKU数量汇总")
    private String maxUnitSum;

    /**
     * 订单日期
     */
    @ApiModelProperty(value = "订单日期")
    private String orderDate;

    /**
     * 交货日期
     */
    @ApiModelProperty(value = "交货日期")
    private String deliveryDate;

    /**
     * 订货单总金额（含税）
     */
    @ApiModelProperty(value = "订货单总金额（含税）")
    private String finalOrderAmount;

    /**
     * 登录帐号
     */
    @ApiModelProperty(value = "登录帐号")
    private String userName;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private String orderCreateDate;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    private String orderUpdateDate;

    /**
     * 创建用户
     */
    @ApiModelProperty(value = "创建用户")
    private String orderCreateName;

    /**
     * 更新用户
     */
    @ApiModelProperty(value = "更新用户")
    private String orderUpdateName;

    /**
     * 公司编码
     */
    @ApiModelProperty(value = "公司编码")
    private String company;

    /**
     * 公司名称
     */
    @ApiModelProperty(value = "公司名称")
    private String companyName;

    /**
     * 售达方编码
     */
    @ApiModelProperty(value = "售达方编码")
    private String soldToPartyCode;

    /**
     * 售达方名称
     */
    @ApiModelProperty(value = "售达方名称")
    private String soldToPartyName;

    /**
     * 送达方编码
     */
    @ApiModelProperty(value = "送达方编码")
    private String deliveryPartyCode;

    /**
     * 送达方名称
     */
    @ApiModelProperty(value = "送达方名称")
    private String deliveryPartyName;

    /**
     * 商超产品编码
     */
    @ApiModelProperty(value = "商超产品编码")
    private String kaGoodsCode;

    /**
     * 商超产品名称
     */
    @ApiModelProperty(value = "商超产品名称")
    private String kaGoodsName;

    /**
     * 门店分类
     */
    @ApiModelProperty(value = "门店分类")
    private String storeType;

    /**
     * 门店分组
     */
    @ApiModelProperty(value = "门店分组")
    private String storeGroup;
}