package com.biz.crm.nebular.mdm.kms.api;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author zxw
 * @date 2021-03-16 14:01
 **/
@Data
public class KmsOrderDetailVo {

    @ApiModelProperty("商超产品编号")
    private String kaGoodsCode;

    @ApiModelProperty("商超产品名称")
    private String kaGoodsName;

    @ApiModelProperty("产品国际条码")
    private String goodsBarCode;

    @ApiModelProperty("企业产品编码")
    private String goodsCode;

    @ApiModelProperty("企业产品名称")
    private String goodsName;

    @ApiModelProperty("验收金额小计（含税）")
    private String acceptanceAmount;

    @ApiModelProperty("产品规格")
    private String specification;

    @ApiModelProperty("订货数量")
    private String orderQuantity;

    @ApiModelProperty("最大单位验收数量")
    private String maxUnitAcceptanceQuantity;

    @ApiModelProperty("当前单位")
    private String curUnit;

    @ApiModelProperty("当前单位验收数量")
    private String curUnitAcceptanceQuantity;

    @ApiModelProperty("最大单位")
    private String maxUnit;

    @ApiModelProperty("最小单位验收数量")
    private String minUnitAcceptanceQuantity;

    @ApiModelProperty("最小单位")
    private String minUnit;

    @ApiModelProperty("企业验收单号/企业退货单编号/企业订货单编号")
    private String orderNumber;

    @ApiModelProperty("最大单位订货数量")
    private String maxUnitOrderQuantity;

    @ApiModelProperty("最小单位订货数量")
    private String minUnitOrderQuantity;

    @ApiModelProperty("当前单位订货数量")
    private String curUnitOrderQuantity;

    @ApiModelProperty("退货单价/订货单价")
    private String unitPrice;

    @ApiModelProperty("客户订货价格")
    private String orderPrice;

    @ApiModelProperty("对比金额差异")
    private String priceDiff;

    @ApiModelProperty("订货金额小计（含税）")
    private String orderAmount;

    @ApiModelProperty("单据类型1:订货单，2.退货单，3.验收单，4.变价单")
    private Integer kmsOrderType;

    private String rawDataId;
}
