package com.biz.crm.nebular.mdm.kms.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * @author zxw
 */
@ApiModel(value = "退货单据")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class KmsReturnVoucherVo {
    /**
     * 企业订货单编号
     */
    @ApiModelProperty(value = "企业订货单编号")
    private String orderNumber;

    /**
     * 客户退货单编号
     */
    @ApiModelProperty(value = "客户退货单编号")
    private String kaOrderNumber;

    /**
     * 关联订货单
     */
    @ApiModelProperty(value = "关联订货单")
    private String relateOrderNumber;

    /**
     * 客户编码
     */
    @ApiModelProperty(value = "客户编码")
    private String kaCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(value = "客户名称")
    private String kaName;

    /**
     * 订单日期
     */
    @ApiModelProperty(value = "订单日期")
    private String orderDate;

    /**
     * 退货金额总计（含税）
     */
    @ApiModelProperty(value = "退货金额总计（含税）")
    private String finalReturnAmount;

    /**
     * 退货原因
     */
    @ApiModelProperty(value = "退货原因")
    private String returnReason;

    /**
     * 商超门店/大仓编号
     */
    @ApiModelProperty(value = "商超门店/大仓编号")
    private String kaStoreCode;

    /**
     * 商超门店/大仓名称
     */
    @ApiModelProperty(value = "商超门店/大仓名称")
    private String kaStoreName;

    /**
     * 登录帐号
     */
    @ApiModelProperty(value = "登录帐号")
    private String userName;

    /**
     * 单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)
     */
    @ApiModelProperty(value = "单据来源(0:自动抓单，1手动抓单，2手动添加，3表格导入)")
    private String invoicesSource;

    /**
     * 企业门店/大仓编号
     */
    @ApiModelProperty(value = "企业门店/大仓编号")
    private String storeCode;

    /**
     * 企业门店/大仓名称
     */
    @ApiModelProperty(value = "企业门店/大仓名称")
    private String storeName;

    /**
     * 门店所属大区
     */
    @ApiModelProperty(value = "门店所属大区")
    private String areaCode;

    /**
     * 业务区域
     */
    @ApiModelProperty(value = "业务区域")
    private String businessArea;

    /**
     * 业务区域负责人
     */
    @ApiModelProperty(value = "业务区域负责人")
    private String businessAreaLeader;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private String orderCreateDate;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    private String orderUpdateDate;

    /**
     * 创建用户
     */
    @ApiModelProperty(value = "创建用户")
    private String orderCreateName;

    /**
     * 更新用户
     */
    @ApiModelProperty(value = "更新用户")
    private String orderUpdateName;
}