package com.biz.crm.nebular.mdm.materialGroup;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @ClassName: MdmMaterialGroupReqVo
 * @Author: yangfan
 * @Description: 物料组请求vo
 * @Date: 2021/8/19 11:18
 * @Version: 1.0
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "MdmMaterialGroupReqVo", description = "物料组请求vo")
@Accessors(chain = true)
public class MdmMaterialGroupReqVo extends CrmExtVo {
  @ApiModelProperty("物料组编码")
  private String materialGroupCode;

  @ApiModelProperty("物料组名称")
  private String materialGroupName;

  @ApiModelProperty("物料组描述")
  private String description;

  @ApiModelProperty("物料数量")
  private Integer materialNum;

  @ApiModelProperty("物料信息")
  private List<MdmMaterialReqVo> materialList;

  /**
   * 物料组编码集合
   */
  @ApiModelProperty("物料组编码集合")
  private List<String> materialGroupCodes;

  /**
   * 物料编码集合
   */
  @ApiModelProperty("物料编码集合")
  private List<String> materialCodes;
  /**
   * 修改/创建开始时间
   */
  @ApiModelProperty("修改开始时间")
  private String startDate;
  /**
   * 修改/创建结束时间
   */
  @ApiModelProperty("修改结束时间")
  private String endDate;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;
}
