package com.biz.crm.nebular.mdm.org.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 组织表返回vo
 *
 * @author Tao.Chen
 * @date 2020-12-07 09:55:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "组织树形结构返回VO")
@CrmColumnResolve
public class MdmOrgTreeRespVo{

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("组织类型（字典mdm_org_type）")
    private String orgType;

    @ApiModelProperty("组织类型名称")
    private String orgTypeName;

    @ApiModelProperty("组织描述")
    private String orgDesc;

    @ApiModelProperty("上级组织编码")
    private String parentCode;

    private String ruleCode;

    private Integer levelNum;

    @ApiModelProperty("直接下级组织")
    private List<MdmOrgTreeRespVo> children;

}