package com.biz.crm.nebular.mdm.permission;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 数据权限返回vo
 *
 * @author zxw
 * @date 2020-10-26 12:09:31
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "组织列表")
@SaturnEntity(name = "MdmDataPermissionOrgVo", description = "组织列表")
@CrmColumnResolve
public class MdmDataPermissionOrgVo {

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("组织层级")
    private String orgType;

    @ApiModelProperty("组织层级名称")
    private String orgTypeName;

    @ApiModelProperty("查询方式类型,1当前组织，2当前及下级组织")
    private String permissionSearchType;

    @ApiModelProperty("查询方式名称")
    @CrmDict(typeCode = DictConstant.PERMISSION_OBJ, dictCodeField = "permissionSearchType")
    private String permissionSearchTypeName;

}