package com.biz.crm.nebular.mdm.product.resp;

import com.biz.crm.config.CrmDict;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author lf
 * @describe
 * @project crm-product
 * @package com.biz.crm.mdm.product.req
 * @date 2021/7/14 13:57
 */
@ApiModel("商品返回数据-sfa专用")
@Data
public class MdmProductBySfaRespVo {

    @ApiModelProperty("商品名称")
    private String productName;

    @ApiModelProperty("商品名称")
    private String productCode;

    @ApiModelProperty("系列编码")
    private String productLevelCode;

    @ApiModelProperty("系列名称")
    private String productLevelName;

    @ApiModelProperty("品牌编码")
    private String brandCode;

    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty("销售单位(字典编码)")
    @SaturnColumn(description = "销售单位(字典编码)")
    private String saleUnit;

    @ApiModelProperty("销售单位")
    @SaturnColumn(description = "销售单位")
    @CrmDict( typeCode = "product_sale_unit", dictCodeField = "saleUnit")
    private String saleUnitName;

    @ApiModelProperty("规格")
    @SaturnColumn(description = "规格")
    private String spec;

    @ApiModelProperty("价格")
    private String price;

    @ApiModelProperty("sfa图片地址")
    private String picUrl;

    @ApiModelProperty("主图片url")
    private String primaryPictureUrl;
}
