package com.biz.crm.nebular.mdm.productlevel.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 产品层级下拉框查询请求VO
 *
 * @author Tao.Chen
 * @date 2020-19-01 12:13:56
 */
@Data
@ApiModel(value = "MdmProductLevelSelectReqVo", description = "")
public class MdmProductLevelSelectReqVo {

    @ApiModelProperty("返回条数，不传返回默认条数")
    private Integer pageSize;

    @ApiModelProperty("生效状态 003停用，009启用")
    private String enableStatus;

    @ApiModelProperty("产品层级编码，查询上级是这个编码的产品层级")
    private String parentCode;

    @ApiModelProperty("产品层级编码，模糊查询")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称，模糊查询")
    private String productLevelName;

    @ApiModelProperty("产品层级名称，模糊查询编码或名称")
    private String productLevelCodeOrName;

    @ApiModelProperty("产品层级类型，精确查询")
    private String productLevelType;

    @ApiModelProperty("产品层级编码，只查询当前产品层级及下级")
    private String underProductLevelCode;

    @ApiModelProperty("产品层级编码，排除当前层级和下级")
    private String notUnderProductLevelCode;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private List<String> selectedCodeList;
}
