package com.biz.crm.nebular.mdm.user.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author ql
 * @date 2021/2/20
 * @time 10:42
 * 终端用户新增编辑终端下拉列表请求vo
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmTerminalUserTerminalSelectReqVo", description = "终端用户新增编辑终端下拉列表请求vo")
public class MdmTerminalUserTerminalSelectReqVo {


    @ApiModelProperty("生效状态 003停用，009启用")
    private String enableStatus;

    @ApiModelProperty("用于确定新增/编辑，新增为空，编辑为被编辑用户的userName")
    private String userName;

    @ApiModelProperty("审批状态,枚举MdmBpmStatusEnum")
    private String actApproveStatus;

    @ApiModelProperty("终端名称，模糊查询")
    private String terminalName;


    @ApiModelProperty("返回条数，不传返回默认条数")
    private Integer pageSize;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private List<String> selectedCodeList;




}
