package com.biz.crm.nebular.mdm.user.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 用户信息表请求vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserEditReqVo", description = "用户新增编辑请求VO")
public class MdmUserEditReqVo extends CrmExtVo {

    @ApiModelProperty("用户账号登录信息")
    private String userName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("角色编码")
    private String roleCode;

    @Deprecated
    @ApiModelProperty("用户编码")
    private String userCode;

    @ApiModelProperty("密码（经过加密的）")
    private String userPassword;

    @ApiModelProperty("用户类型")
    private String userType;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("电话")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    private String fullName;

    @ApiModelProperty("生效时间")
    private String endTime;

    @ApiModelProperty("失效时间")
    private String startTime;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("职位列表")
    private List<MdmUserPositionEditReqVo> positionList;

    @ApiModelProperty("客户列表")
    private List<MdmUserCustomerEditReqVo> customerList;

    @ApiModelProperty("用户头像url")
    private String userHeadUrl;

    @ApiModelProperty("权限角色编码集合")
    private List<String> roleCodeList;

    @ApiModelProperty("工号")
    private String jobCode;

    @ApiModelProperty("员工类型")
    private String employeeType;

    @ApiModelProperty("员工状态")
    private String employeeStatus;

    @ApiModelProperty("身份证号码")
    private String identityCardNumber;

    @ApiModelProperty("身份证地址")
    private String identityCardAddress;

    @ApiModelProperty("民族")
    private String nationality;

    @ApiModelProperty("现住址")
    private String currentAddress;

    @ApiModelProperty("政治面貌")
    private String politicalAffiliation;

}