package com.biz.crm.nebular.mdm.user.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户-终端关联：分页请求
 *
 * @author zxw
 * @date 2020-10-15 10:21
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserRelationTerminalPageReqVo", description = "用户-终端关联：分页请求")
public class MdmUserRelationTerminalPageReqVo extends CrmExtVo {

    @ApiModelProperty("终端类型")
    private String terminalType;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("省编码")
    private String provinceCode;

    @ApiModelProperty("市编码")
    private String cityCode;

    @ApiModelProperty("区编码")
    private String districtCode;

    @ApiModelProperty("省名称")
    private String provinceName;

    @ApiModelProperty("市名称")
    private String cityName;

    @ApiModelProperty("区名称")
    private String districtName;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty("终端名称或编码")
    private String terminalCodeOrName;

    @ApiModelProperty("用户帐号")
    private String userName;

    @ApiModelProperty("审批状态,枚举MdmBpmStatusEnum")
    private String actApproveStatus;

}
