package com.biz.crm.nebular.order;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @Author: huojia
 * @DateTime: 2021/1/28 19:05
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "订单汇总行数据Vo")
public class OrderDetailCollectVo extends CrmExtVo {

    @ApiModelProperty(value = "商品编码")
    private String productCode;

    @ApiModelProperty(value = "商品sap编码(物料编码)")
    private String productSapCode;

    @ApiModelProperty(value = "商品名称")
    private String productName;

    @ApiModelProperty(value = "规格")
    private String spec;

    @ApiModelProperty(value = "数量")
    private BigDecimal productNum;

    @ApiModelProperty(value = "总重量(克)")
    private BigDecimal weightOfGram;

    @ApiModelProperty(value = "总重量(千克)")
    private BigDecimal weightOfKilogram;

    @ApiModelProperty(value = "总重量(吨)")
    private BigDecimal weightOfTon;

    @ApiModelProperty(value = "销售单位编码")
    private String salesUnit;

    @ApiModelProperty(value = "销售单位名称")
    private String salesUnitName;

    @ApiModelProperty(value = "本行总金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "默认商品图片")
    private String imgUrl;

    @ApiModelProperty(value = "产品层级编码")
    private String productLevelCode;
}