package com.biz.crm.nebular.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.order.vo
 * @Description: TODO
 * @date 2021/1/29 下午2:35
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "订单行所用促销信息")
public class OrderDetailPromotionVo implements Serializable {

    @ApiModelProperty(value = "订单编码")
    private String orderCode;

    @ApiModelProperty(value = "订单行号")
    private String orderDetailLineNo;

    @ApiModelProperty(value = "促销code")
    private String promotionCode;

    @ApiModelProperty(value = "促销名称")
    private String promotionName;

    @ApiModelProperty(value = "促销id")
    private String promotionPolicyId;

    @ApiModelProperty(value = "促销类型")
    private String promotionType;

    @ApiModelProperty(value = "促销金额")
    private BigDecimal promotionAmount;

    @ApiModelProperty(value = "促销计算描述")
    private String promotionDes;

    @ApiModelProperty(value = "是否组合")
    private String combinationFlag;

    @ApiModelProperty(value = "促销计算顺序")
    private Integer sortNum;

    @ApiModelProperty(value = "算价是否成功标识(YesNoEnum)")
    private String calSucessFlag;

    @ApiModelProperty(value = "算价失败提示语")
    private String calSucessMsg;

}
