package com.biz.crm.nebular.order;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.order.vo
 * @Description: TODO
 * @date 2021/1/29 下午2:35
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "订单行分组vo")
public class OrderGroupItemVo implements Serializable {

    @ApiModelProperty(value = "本品")
    private List<OrderDetailVo> normalList;

    @ApiModelProperty(value = "赠品")
    private List<OrderDetailVo> giftList;

    @ApiModelProperty(value = "货补")
    private List<OrderDetailVo> backList;

    @ApiModelProperty(value = "补货商品")
    private List<OrderDetailVo> reissueList;

    @ApiModelProperty(value = "分组编码")
    private String groupCode;

    @ApiModelProperty(value = "该组优惠金额")
    private BigDecimal promotionAmount;

    @ApiModelProperty(value = "该组促销商品最大可购数量")
    private BigDecimal promotionMaxGiftValue;

    @ApiModelProperty(value = "该组是否是买赠分组（Y是;N否）")
    private String buyAndGiveFlag;

    @ApiModelProperty(value = "买赠提示语(比如剩余多少可选金额)")
    private String buyAndGiveMsg;

    @ApiModelProperty(value = "买赠促销名称")
    private String promotionName;

    @ApiModelProperty(value = "买赠促销编码")
    private String promotionCode;

    @ApiModelProperty(value = "算价是否成功标识(YesNoEnum)")
    private String calSucessFlag;

    @ApiModelProperty(value = "算价失败提示语")
    private String calSucessMsg;
}
