package com.biz.crm.nebular.rebate.expression;

import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Author: chenrong
 * @Date: 2021/1/15 15:49
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RebateExecuteComputeResult implements Serializable {

  private static final long serialVersionUID = -2938801736963510726L;

  /**
   * 计算结果
   */
  private BigDecimal value;
  /**
   * 计算过程描述
   */
  private String computeProcess;
  /**
   * 计算取值过程（参数）
   */
  private String computeProcessResult;
  /**
   * 替换变量后的表达式
   */
  private String expressValue;
  /**
   * 原始表达式
   */
  private String expressStr;
}
